 'SQUASH AND PING-PONG GAMES WITH SCOREBOARD
'Bascom-Avr IDE [2.0.7.5]
'Flash used: 3968 Bytes
'Micro:ATmega16A
'Author: Mahmood Alimohammadi
'Date: December 5 , 2016
'*******************************************************************************
$regfile = "m16adef.dat"
$crystal = 1000000

Config Lcd = 16 * 2
Config Lcdpin = Pin , Db4 = Portc.0 , Db5 = Portc.1 , Db6 = Portc.2 , Db7 = Portc.3 , Rs = Portc.4 , E = Portc.5

Config Adc = Single , Prescaler = Auto , Reference = Avcc

Config Portb = Output
Config Portd = Output
Config Portc.7 = Output

Config Porta = Input
Porta = 255                                                 'Pullup resisttors

Player1 Alias Pina.0
Player2 Alias Pina.1
Score_reset Alias Pina.2
Selector Alias Pina.3

Speaker Alias Portc.7
Led1 Alias Portb.0
Led16 Alias Portd.7
'-------------------------------------------------------------------------------
Dim Shifter As Byte , Starter As Bit , Pot As Word
Dim Points1 As Byte , Points2 As Byte , Play1 As Bit , Play2 As Bit , Button1 As Bit
Dim Button2 As Bit , Player1_game As Byte , Player2_game As Byte
Dim Pulses As Byte , Periods As Byte

Dim Eep_player1 As Eram Byte , Eep_player2 As Eram Byte
Dim Eep_player1_game As Eram Byte , Eep_player2_game As Eram Byte

Declare Sub Pingpong : Declare Sub Squash : Declare Sub Eeprom_erase
'-------------------------------------------------------------------------------
Shifter = 0 : Starter = 0 : Points1 = 0 : Points2 = 0
Play1 = 0 : Play2 = 0 : Button1 = 0 : Button2 = 0 : Player1_game = 0 : Player2_game = 0

'*******************************************************************************
'Read from the EEPROM and display
Points1 = Eep_player1 : Points2 = Eep_player2
Player1_game = Eep_player1_game : Player2_game = Eep_player2_game
Gosub Screen
'-------------------------------------------------------------------------------

Start Adc

Do
Pot = Getadc(4)                                             'Connect pot to pin PA4.
Pot = Pot / 2

If Selector = 1 Then Call Pingpong Else Call Squash

If Score_reset = 0 Then Call Eeprom_erase

Loop
End
'*******************************************************************************
Sub Pingpong
If Player1 = 0 And Starter = 0 Then                         'Lightup LED1
Led1 = 1 : Led16 = 0 : Starter = 1 : Wait 1 : End If

If Player1 = 0 And Starter = 1 And Led16 = 0 Then           'Player1:start or continue playing.
Gosub Sounder

Led1 = 1

For Shifter = 0 To 7 : Gosub Pause : Shift Portb , Left     'Left shift PORTB.

If Player2 = 0 Then Goto Score1
Next

End If

'-------------------------------------------------------------------------------
If Shifter >= 7 Then
Portd.0 = 1

For Shifter = 0 To 7 : Gosub Pause : Shift Portd , Left     'Left shift PORTD

If Shifter = 7 Then Gosub Sounder
If Shifter = 7 And Player2 = 1 Then : Gosub Pause : Goto Score1 : End If

If Shifter < 7 And Player2 = 0 Then Goto Score1
Next
End If
'-------------------------------------------------------------------------------
If Player2 = 0 And Starter = 0 Then                         'Lightup LED16.
Led16 = 1 : Led1 = 0 : Starter = 1 : Wait 1 : End If

If Player2 = 0 And Starter = 1 And Led1 = 0 Then            'Player2:start or continue playing.
Gosub Sounder

Led16 = 1
For Shifter = 0 To 7 : Gosub Pause : Shift Portd , Right    'Right shift PORTD.

If Player1 = 0 Then Goto Score2
Next
End If
'-------------------------------------------------------------------------------
If Shifter >= 7 Then
Portb.7 = 1

For Shifter = 0 To 7 : Gosub Pause : Shift Portb , Right    'Right shift PORTB
If Shifter = 7 Then Gosub Sounder
If Shifter = 7 And Player1 = 1 Then : Gosub Pause : Goto Score2 : End If

If Shifter < 7 And Player1 = 0 Then Goto Score2
Next
End If
End Sub
'*******************************************************************************
Sub Squash

If Player1 = 0 And Starter = 0 Then                         'Player1:lightup LED1.
Led1 = 1 : Starter = 1 : Button1 = 1 : Wait 1 : End If

If Player1 = 0 And Starter = 1 And Button1 = 1 Then         'Player1:start or continue playing.

Gosub Sounder
Led1 = 1 : Play1 = 1 : Play2 = 0 : Button1 = 0 : Button2 = 1

For Shifter = 0 To 7 : Gosub Pause : Shift Portb , Left     'Left shift PORTB.

If Player2 = 0 Then Goto Score1
Next
End If
'-------------------------------------------------------------------------------
If Player2 = 0 And Starter = 0 Then                         'Player2:lightup LED1.

Led1 = 1 : Starter = 1 : Button2 = 1 : Wait 1 : End If

If Player2 = 0 And Starter = 1 And Button2 = 1 Then         'Player2:start or continue playing.

Gosub Sounder
Led1 = 1 : Play2 = 1 : Play1 = 0 : Button2 = 0 : Button1 = 1

For Shifter = 0 To 7 : Gosub Pause : Shift Portb , Left     'Left shift PORTB.

If Player1 = 0 Then Goto Score2
Next
End If
'-------------------------------------------------------------------------------
If Shifter >= 7 Then
Portd.0 = 1

For Shifter = 0 To 6 : Gosub Pause : Shift Portd , Left     'Left shift PORTD.

If Play1 = 1 And Player2 = 0 Then Goto Score1
If Play2 = 1 And Player1 = 0 Then Goto Score2
Next
'-------------------------------------------------------------------------------
If Led16 = 1 Then
Sound Speaker , 250 , 75
End If

For Shifter = 0 To 7 : Gosub Pause : Shift Portd , Right    'Right shift PORTD.

If Player1 = 0 Then Goto Score2
If Player2 = 0 Then Goto Score1
Next
End If
'-------------------------------------------------------------------------------
If Shifter >= 7 Then
Portb.7 = 1

For Shifter = 0 To 7 : Gosub Pause : Shift Portb , Right    'Right shift PORTB.
If Shifter = 7 Then Gosub Sounder
'-------------------------------------------------------------------------------
If Shifter = 7 And Play2 = 1 And Player1 = 1 Then
Gosub Pause : Goto Score2 : End If

If Shifter = 7 And Play1 = 1 And Player2 = 1 Then
Gosub Pause : Goto Score1 : End If

If Shifter < 7 And Player1 = 0 Then Goto Score2
If Shifter < 7 And Player2 = 0 Then Goto Score1
Next
End If
End Sub
'*******************************************************************************
'Erase EEPROM and clear screen figures.
Sub Eeprom_erase
Eep_player1 = 0 : Eep_player2 = 0 : Eep_player1_game = 0 : Eep_player2_game = 0

Points1 = 0 : Points2 = 0 : Player1_game = 0 : Player2_game = 0
Sound Speaker , 100 , 200

Gosub Screen
End Sub
'-------------------------------------------------------------------------------
Sounder:
Sound Speaker , 75 , 75
'-------------------------------------------------------------------------------
Screen:
Cursor Off
Cls
Locate 1 , 1 : Lcd "Player1:" ; Points1
Locate 1 , 14 : Lcd Player1_game
Locate 2 , 1 : Lcd "Player2:" ; Points2
Locate 2 , 14 : Lcd Player2_game
Return
'-------------------------------------------------------------------------------
'Player1's scored points and games
Score1:
Incr Points1
If Points1 = 11 Then
Incr Player1_game : Points1 = 0 : Points2 = 0 : Eep_player1 = 0 : Eep_player2 = 0
Sound Speaker , 250 , 100

End If
'Write points and game info of player1 into EEPROM.
Eep_player1 = Points1
Eep_player1_game = Player1_game
Gosub Screen
Gosub Stopprogram

'-------------------------------------------------------------------------------
'Player2's scored points and games
Score2:
Incr Points2
If Points2 = 11 Then
Incr Player2_game : Points1 = 0 : Points2 = 0 : Eep_player1 = 0 : Eep_player2 = 0
Sound Speaker , 250 , 100

End If
'Write points and game info of player2 into EEPROM.
Eep_player2 = Points2
Eep_player2_game = Player2_game
Gosub Screen
Gosub Stopprogram
'-------------------------------------------------------------------------------
Stopprogram:
Sound Speaker , 200 , 50
Portb = 0
Portd = 0
Stop
 '------------------------------------------------------------------------------
 'Use the pot to adjust the rate of the movement of the light by changing the delay between shifts.
 Pause:
Select Case Pot
Case 0 To 100 : Waitms 400
Case 101 To 200 : Waitms 300
Case 201 To 300 : Waitms 200
Case 301 To 400 : Waitms 100
Case Is > 400 : Waitms 50
End Select
Return
'END OF PROGRAM
'*******************************************************************************